/**
 * ======================================================================
 * 
 * IML REDIRECT :: JAVASCRIPT FUNCTIONS
 * 
 * ----------------------------------------------------------------------
 * 2022-05-23  ah  v0.1   initial version
 * 2025-01-13  ah  v1.0   colorize clicked testlink in dependency of the result
 * ======================================================================
 */


// ----------------------------------------------------------------------
// CONFIG
// ----------------------------------------------------------------------

let divOut="divoverlay";

// ----------------------------------------------------------------------
// FUNCTIONS
// ----------------------------------------------------------------------

/**
 * show given html code in overlay
 * @param {string} body  html code to display
 */
async function show(body){
    oDiv=document.getElementById(divOut);
    oDiv.innerHTML='<div>'+body+'</div>';
    oDiv.style.display='block';
}

/**
 * show content of a url in the overlay
 * @param {object} oLink  link object; in a tag use this to reference itself
 */
async function showInOverlay(oLink){
    show(
      '<h2>Please wait ...</h2>'
      +'<p>Requesting data...<div class="spin"></div></p>'
    );
    let response = await fetch(oLink.href);
    let body = await response.text(); // read response body as text


    if (response.ok) {
      show(body);

      // colorize clicked link
      var spans=document.getElementsByClassName("status");
      if(spans){
        var myspan=spans[spans.length-1];
        var myclass=myspan.className.replace("status ","");
        oLink.className=myclass;
        oLink.title=myspan.innerText;  
      }
    } else {
      show("HTTP-Error: " + response.status);
    }
    
}



// ----------------------------------------------------------------------
// page init
// ----------------------------------------------------------------------

// init datatable
$(document).ready( function () {
    $('.mydatatable').DataTable({
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        stateSave: true
    });
} );

// ----------------------------------------------------------------------